
import java.util.*;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/** class for creating a thumbnail canvas for a 
    given image */

public class Thumbnail extends JPanel {

	public static final int SIZE= 60;
	private static Font labelFont = new Font("Helvetica",Font.BOLD,10);

	
	ImageBox vImage;              // the image
	
	boolean fontSet= false;       // = the font has been set
	FontMetrics labelFontMetrics; // the font metrics

	/** Constructor: a thumbnail of image v */
	public Thumbnail(ImageBox v) {
		vImage= v;
		addMouseListener(new LocalMouseListener());
	}

    // = the height of the thumbnail
    private int newGetHeight() {
       return SIZE * vImage.image.getHeight(this)/vImage.image.getWidth(this);
	}
    
	// = the width of the thumbnail
    private int newGetWidth() {
      return SIZE;
	}

	/** paint the image and a label on the canvas */
	public void paint(Graphics g) {
        // set the font --only once
		   if (!fontSet) { 
			   labelFontMetrics = g.getFontMetrics(labelFont);
			   fontSet= true;
			}
	   // draw the thumbnail
		    g.drawImage(vImage.image,0,0,newGetWidth(),newGetHeight(),
				0,0,vImage.image.getWidth(this),vImage.image.getHeight(this),this);
	   // draw the label
			g.setFont(labelFont);
	        g.drawString(vImage.filename,
				/*(newGetWidth()-labelFontMetrics.stringWidth(vImage.filename))/2,*/0,
				(newGetHeight()+labelFontMetrics.getAscent()+1));
	}

	/** methods used by system to size canvas */
	public Dimension getPreferredSize() {
		return new Dimension(newGetWidth()+1,newGetHeight()+15);
	}
	  
	public Dimension getMinimumSize() {
		return new Dimension(newGetWidth()+1,newGetHeight()+15);
	}
	  
    /** inner class for processing mouse clicks thumbnail */
    class LocalMouseListener implements MouseListener{

	  public void mousePressed(MouseEvent e) {
		  vImage.handler.setCurrentImage(vImage.imagenum);
	  }		 
         
	  public void mouseReleased(MouseEvent e) {}

      public void mouseEntered(MouseEvent e) {}

      public void mouseExited(MouseEvent e) {}

      public void mouseClicked(MouseEvent e) {}
  }
} 

